/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xepp32.c
 * -----------------------------------------------------------------*/

#include <xtypedef.h>

#include <windows.h>
#include <winioctl.h>

#include <xerrcapi.h>

#include <b_ioctl.h>
#include <b_ntepp.h>

#include <xepp.h>
#include <xlasterr.h>
#include <timeout.h>


/* --------------------------------------------------------------------------
 * STATICS
 * -------------------------------------------------------------------------- */

static bx_int8 BestXParReceiveByteIoctl(HANDLE OsHandle, int portoffset);
static bx_errtype BestXParSendByteIoctl(HANDLE OsHandle, int portoffset, bx_int8 data);


/******************************************************************************/
static bx_int8 BestXParReceiveByteIoctl(HANDLE OsHandle, int portoffset)
{
  BOOL fIoCtlSuccess;
  ULONG ReturnedLength;
  bx_int8 data;
  ULONG PortNumber = (ULONG) portoffset;

  fIoCtlSuccess = DeviceIoControl(
    OsHandle,                  /* Handle to device  */
    IOCTL_NTIO_READ_PORT_UCHAR, /* IO Control code for Read */
    &PortNumber,                /* Buffer to driver. */
    sizeof(PortNumber),         /* Length of buffer in bytes. */
    &data,                      /* Buffer from driver.  */
    sizeof(data),               /* Length of buffer in bytes. */
    &ReturnedLength,            /* Bytes placed in DataBuffer. */
    NULL                        /* NULL means wait till op. completes. */
    );

  if (!fIoCtlSuccess || (ReturnedLength != sizeof(data)))
  {
    /* close connection, still to be implemented */
    return 0x0;
  }

  return data;
}


/******************************************************************************/
static bx_errtype BestXParSendByteIoctl(HANDLE OsHandle, int portoffset, bx_int8 data)
{
  BOOL fIoCtlSuccess;
  ULONG ulReturnedLength;
  BESTNTIO_WRITE_INPUT InputBuffer;
  ULONG DataLength;

  InputBuffer.PortNumber = (ULONG) portoffset;
  InputBuffer.Data.CharData = data;
  DataLength = offsetof(BESTNTIO_WRITE_INPUT, Data) + sizeof(InputBuffer.Data.CharData);

  fIoCtlSuccess = DeviceIoControl(
    OsHandle,                  /* Handle to device */
    IOCTL_NTIO_WRITE_PORT_UCHAR,  /* IO Control code for Write */
    &InputBuffer,               /* Buffer to driver.  Holds port & data. */
    DataLength,                 /* Length of buffer in bytes. */
    NULL,                       /* Buffer from driver.   Not used. */
    0,                          /* Length of buffer in bytes.  */
    &ulReturnedLength,          /* Bytes placed in outbuf.  Should be 0. */
    NULL                        /* NULL means wait till I/O completes. */
    );

  DBG_ApiFailureIsZero(fIoCtlSuccess);

  if (!fIoCtlSuccess)
  {
    return BX_E_API_ERROR;
  }
  return BX_E_OK;
}



/******************************************************************************/
bx_portnumtype BestXOpenParallel(int num)
{
  HANDLE OsHandle;

  switch (num)
  {
    case BX_PORT_LPT1:
      OsHandle = CreateFile(
        CREATE_FILE_NAME_EPP0,
        GENERIC_WRITE | GENERIC_READ,
        FILE_SHARE_WRITE,
        NULL,
        OPEN_EXISTING,
        0,
        NULL);
      break;

    case BX_PORT_LPT2:
      OsHandle = CreateFile(
        CREATE_FILE_NAME_EPP1,
        GENERIC_WRITE | GENERIC_READ,
        FILE_SHARE_WRITE,
        NULL,
        OPEN_EXISTING,
        0,
        NULL);
      break;

    default:
      OsHandle = INVALID_OS_HANDLE;
  }

  if (OsHandle == INVALID_HANDLE_VALUE)
  {
    return INVALID_OS_HANDLE;
  }

  return (bx_portnumtype) OsHandle;
}


/******************************************************************************/
void BestXCloseParallel(bx_portnumtype portnumber)
{
  (void) CloseHandle((HANDLE) portnumber);
}


/* --------------------------------------------------------------------------
 * Should only be called from BestDeviceConnect()
 * -------------------------------------------------------------------------- */

bx_errtype BestXParDeviceConnect(bx_portnumtype OsHandle)
{
  bx_int8 CurrControl = BestXParReceiveByteIoctl(OsHandle, LPT_CONTROL);

  /* set connect bit to 0 */
  CurrControl = CurrControl & ~LPT_SELECT_IN;

  /* and send it */
  return BestXParSendByteIoctl((HANDLE) OsHandle, LPT_CONTROL, CurrControl);
}

/* --------------------------------------------------------------------------
 * Should only be called from BestCheckConnection()
 * -------------------------------------------------------------------------- */

bx_errtype BestXParCheckConnection(bx_portnumtype OsHandle)
{
  if ((BestXParReceiveByteIoctl(OsHandle, LPT_STATUS) & LPT_SELECT) != 0)
  {
    return BX_E_NOT_CONNECTED;
  }

  return BX_E_OK;
}

/* --------------------------------------------------------------------------
 * Should only be called from BestReleaseConnection()
 * -------------------------------------------------------------------------- */

void BestXParReleaseConnection(bx_portnumtype OsHandle)
{
  (void) BestXParSendByteIoctl((HANDLE) OsHandle, LPT_CONTROL, LPT_SELECT_IN);
}


/* --------------------------------------------------------------------------
 * Should only be called from BestPortTimeoutSet()
 * -------------------------------------------------------------------------- */
bx_errtype BestXParPortTimeoutSet(bx_portnumtype OsHandle, 
                                BESTTIMEOUTS * pCallersTimeouts)
{
  BOOL fIoCtlSuccess;
  ULONG ReturnedLength = 0;

  fIoCtlSuccess = DeviceIoControl(
    (HANDLE) OsHandle,          /* Handle to device  */
    (ULONG) IOCTL_NTIO_SET_TIMEOUT, /* IO Control code for setting timeouts */
    (PVOID)pCallersTimeouts,    /* Buffer to driver. */
    sizeof(BESTTIMEOUTS),       /* Length of buffer in bytes. */
    NULL,                       /* Buffer from driver.  */
    0,                          /* Length of buffer in bytes. */
    &ReturnedLength,            /* Bytes placed in DataBuffer. */
    NULL                        /* NULL means wait till op. completes. */
    );

  DBG_ApiFailureIsZero(fIoCtlSuccess);

  if (!fIoCtlSuccess) 
  {
    return BX_E_API_ERROR;
  }
  
  return BX_E_OK;
}
